/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.scripting.snippets.CommandTemplate;
import com.aptana.editor.common.scripting.snippets.Messages;
import com.aptana.editor.common.scripting.snippets.SnippetTemplate;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.ui.epl.scripting.snippets.PositionBasedCompletionProposal;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetTemplateProposal
extends TemplateProposal
implements ICommonCompletionProposal,
ICompletionProposalExtension6,
Comparable<ICompletionProposal> {
    protected ICompletionProposal[] templateProposals;
    protected char triggerChar;
    protected char[] triggerChars;
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final IRegion fRegion;
    private int fRelevance;
    private ICompletionProposal delegateTemplateProposal;
    private IRegion fSelectedRegion;
    private InclusivePositionUpdater fUpdater;
    private StyledString styledDisplayString;
    private StyledString styledActivationString;
    private StyledString.Styler styler;
    private Integer fReplaceOffset;
    private static final String TRIGGER_CHARS = "123456789";

    public SnippetTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
        this.fTemplate = template;
        this.fContext = context;
        this.fRegion = region;
        this.fTemplate.getContextTypeId();
        EditorUtil.getSpaceIndentSize();
    }

    public String getAdditionalProposalInfo() {
        return this.getTemplate().getPattern();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.delegateTemplateProposal = null;
        if (SnippetTemplateProposal.contains(this.triggerChars, trigger)) {
            if (this.triggerChar == trigger) {
                this.doApply(viewer, trigger, stateMask, offset);
            } else {
                this.delegateTemplateProposal = this.templateProposals[trigger - 49];
                ((ICompletionProposalExtension2)this.templateProposals[trigger - 49]).apply(viewer, trigger, stateMask, offset);
            }
        } else {
            this.doApply(viewer, trigger, stateMask, offset);
        }
    }

    protected void doApply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            int oldReplaceOffset = this.getReplaceOffset(document, this.fTemplate);
            if (this.fTemplate instanceof SnippetTemplate) {
                String prefix;
                ((SnippetTemplate)this.fTemplate).setIndentedPattern(null);
                IRegion lineInformationOfStart = document.getLineInformationOfOffset(oldReplaceOffset);
                int lineInformationOfStartOffset = lineInformationOfStart.getOffset();
                if (oldReplaceOffset > lineInformationOfStartOffset && (prefix = document.get(lineInformationOfStartOffset, oldReplaceOffset - lineInformationOfStartOffset)).matches("\\s+.*")) {
                    String indentedPattern = this.fTemplate.getPattern().replaceAll("(\r\n|\r|\n)", "$1" + prefix.replaceFirst("(\\s+).*", "$1"));
                    indentedPattern = this.conformIndents(prefix, indentedPattern);
                    ((SnippetTemplate)this.fTemplate).setIndentedPattern(indentedPattern);
                }
            }
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException e) {
                IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Error in template {0}. {1}", this.fTemplate.toString(), e.getMessage()));
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int start = this.getReplaceOffset(document, this.fTemplate);
            int shift = start - oldReplaceOffset;
            int end = Math.max(this.getReplaceEndOffset(), offset + shift);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            int defaultSequenceNumber = -1;
            TemplateVariable[] templateVariableArray = variables;
            int n = variables.length;
            int indentedPattern = 0;
            while (indentedPattern < n) {
                TemplateVariable templateVariable = templateVariableArray[indentedPattern];
                String type = templateVariable.getType();
                if ("tabstop".equals(type)) {
                    try {
                        Integer.parseInt(templateVariable.getName());
                        defaultSequenceNumber = 0x7FFFFFFE;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++indentedPattern;
            }
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    int sequenceNumber = defaultSequenceNumber;
                    String type = variable.getType();
                    if ("tabstop".equals(type)) {
                        try {
                            sequenceNumber = Integer.parseInt(variable.getName());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    String[] values = variable.getValues();
                    ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                    int j = 0;
                    while (j < values.length) {
                        this.ensurePositionCategoryInstalled(document, model);
                        Position pos = new Position(offsets[0] + start, length);
                        document.addPosition(this.getCategory(), pos);
                        proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                        ++j;
                    }
                    Object first = proposals.length > 1 ? new ProposalPosition(document, offsets[0] + start, length, sequenceNumber, proposals) : new LinkedPosition(document, offsets[0] + start, length, sequenceNumber);
                    int j2 = 0;
                    while (j2 != offsets.length) {
                        if (j2 == 0) {
                            group.addPosition(first);
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j2] + start, length));
                        }
                        ++j2;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.ensurePositionCategoryRemoved(document);
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        if (this.fSelectedRegion == null) {
            this.fSelectedRegion = this.fRegion;
        }
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset(document, this.fTemplate);
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.fTemplate.getName().startsWith(content);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private synchronized int getReplaceOffset(IDocument document, Template template) {
        block7: {
            if (this.fReplaceOffset == null) {
                if (template instanceof CommandTemplate) {
                    try {
                        String prefix;
                        CommandTemplate ct = (CommandTemplate)template;
                        int fullPrefixOffset = this.getReplaceOffset();
                        String origPrefix = prefix = document.get(fullPrefixOffset, this.getReplaceEndOffset() - fullPrefixOffset);
                        while (!ct.matches(prefix)) {
                            prefix = SnippetsCompletionProcessor.narrowPrefix(prefix);
                        }
                        if (prefix.length() == 0) {
                            this.fReplaceOffset = fullPrefixOffset;
                            break block7;
                        }
                        this.fReplaceOffset = fullPrefixOffset + (origPrefix.length() - prefix.length());
                    }
                    catch (BadLocationException e) {
                        this.fReplaceOffset = this.getReplaceOffset();
                    }
                } else {
                    this.fReplaceOffset = this.getReplaceOffset();
                }
            }
        }
        return this.fReplaceOffset;
    }

    protected String conformIndents(String prefix, String indentedPattern) {
        boolean useTabs = prefix.contains("\t");
        int indentSize = EditorUtil.getSpaceIndentSize();
        Pattern p = Pattern.compile("(\r\n|\r|\n)(\\s*)");
        Matcher m = p.matcher(indentedPattern);
        int startIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (m.find(startIndex)) {
            builder.append(indentedPattern.substring(startIndex, m.start(1)));
            startIndex = m.end(2);
            String indent = EditorUtil.convertIndent(m.group(2), indentSize, useTabs);
            builder.append(m.group(1));
            builder.append(indent);
        }
        builder.append(indentedPattern.substring(startIndex));
        indentedPattern = builder.toString();
        return indentedPattern;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    SnippetTemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "SnippetTemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)Messages.SnippetTemplateProposal_TITLE_SnippetTemplateProposalError, (String)e.getMessage());
    }

    public Point getSelection(IDocument document) {
        if (this.delegateTemplateProposal == null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        return this.delegateTemplateProposal.getSelection(document);
    }

    public char[] getTriggerCharacters() {
        return this.triggerChars;
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString().trim();
    }

    public String getActivationString() {
        return this.getStyledActivationString().getString().trim();
    }

    public StyledString getStyledDisplayString() {
        if (this.styledDisplayString == null) {
            Template template = this.getTemplate();
            this.styledDisplayString = new StyledString(template.getDescription(), this.styler);
        }
        return this.styledDisplayString;
    }

    public StyledString getStyledActivationString() {
        if (this.styledActivationString == null) {
            Template template = this.getTemplate();
            this.styledActivationString = new StyledString(String.valueOf(String.format("%1$10.10s ", String.valueOf(template.getName()) + " \u00bb")) + (this.triggerChar == '\u0000' ? " " : String.valueOf(this.triggerChar)) + ("win32".equals(Platform.getOS()) ? "                                " : ""), this.styler);
        }
        return this.styledActivationString;
    }

    Template getTemplateSuper() {
        return super.getTemplate();
    }

    public void setTriggerChar(char triggerChar) {
        this.triggerChar = triggerChar;
    }

    void setStyler(StyledString.Styler styler) {
        this.styler = styler;
    }

    void setTemplateProposals(ICompletionProposal[] templateProposals) {
        this.templateProposals = templateProposals;
        this.triggerChars = new char[Math.min(templateProposals.length, TRIGGER_CHARS.length())];
        TRIGGER_CHARS.getChars(0, this.triggerChars.length, this.triggerChars, 0);
    }

    protected static boolean contains(char[] characters, char c) {
        if (characters == null) {
            return false;
        }
        int i = 0;
        while (i < characters.length) {
            if (c == characters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFileLocation() {
        return this.getActivationString();
    }

    public Image[] getUserAgentImages() {
        return null;
    }

    public boolean isDefaultSelection() {
        return false;
    }

    public boolean isSuggestedSelection() {
        return false;
    }

    public void setIsDefaultSelection(boolean isDefault) {
    }

    public void setIsSuggestedSelection(boolean isSuggested) {
    }

    public String getExtraInfo() {
        return this.getActivationString();
    }

    @Override
    public int compareTo(ICompletionProposal o) {
        if (this == o) {
            return 0;
        }
        Template t = this.getTemplate();
        if (t == null) {
            return -1;
        }
        if (o instanceof SnippetTemplateProposal) {
            Template t2 = ((SnippetTemplateProposal)o).getTemplate();
            if (t2 == null) {
                return 1;
            }
            return StringUtil.compareCaseInsensitive((String)t.getName(), (String)t2.getName());
        }
        return StringUtil.compareCaseInsensitive((String)t.getName(), (String)o.getDisplayString());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public boolean validateTrigger(IDocument document, int offset, KeyEvent keyEvent) {
        try {
            int replaceOffset = this.getReplaceOffset(document, this.fTemplate);
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.fTemplate.getName().equals(content);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

